﻿using System;
using System.Collections.Generic;

namespace AppFirst
{
    public class Program
    {
        public static void Main(string[] args)
        {
            int opcionSeleccionada = 0;
            int x;

            string nombre, apellido;
            string[] personaTemporal;

            List<string[]> personas = new List<string[]>();

            while (opcionSeleccionada != 5)
            {
                Console.WriteLine("1. Insertar persona.");
                Console.WriteLine("2. Listar personas.");
                Console.WriteLine("3. Editar persona.");
                Console.WriteLine("4. Eliminar persona.");
                Console.WriteLine("5. Salir.");
                Console.WriteLine("----------------------------------------------------");
                Console.WriteLine("Ingrese una opción:");

                string opcionSeleccionadaTemporal = Console.ReadLine();

                if (int.TryParse(opcionSeleccionadaTemporal, out x))
                {
                    opcionSeleccionada = int.Parse(opcionSeleccionadaTemporal);

                    switch (opcionSeleccionada)
                    {
                        case 1:
                            Console.WriteLine("Ingrese el nombre:");
                            nombre = Console.ReadLine();
                            Console.WriteLine("Ingrese el apellido:");
                            apellido = Console.ReadLine();

                            if (nombre.Trim() == string.Empty || apellido.Trim() == string.Empty)
                            {
                                Console.WriteLine("Los campos son obligatorios.");
                            }
                            else
                            {
                                personaTemporal = new string[2];

                                personaTemporal[0] = nombre;
                                personaTemporal[1] = apellido;

                                personas.Add(personaTemporal);
                            }

                            break;
                        case 2:
                            Console.WriteLine("-------------Lista de personas-----------------");

                            foreach (string[] item in personas)
                            {
                                Console.WriteLine(item[0] + " " + item[1]);
                            }

                            break;
                        case 3:
                            Console.WriteLine("-------------Lista de personas-----------------");

                            for (int i=0; i<personas.Count; i++)
                            {
                                Console.WriteLine(i+". "+personas[i][0] + " " + personas[i][1]);
                            }

                            Console.WriteLine("-----------------------------------------------");
                            Console.WriteLine("");

                            Console.WriteLine("Ingrese la persona que quiere editar:");

                            string posicionPersonaTemporal = Console.ReadLine();

                            if (int.TryParse(posicionPersonaTemporal, out x))
                            {
                                int posicionPersona = int.Parse(posicionPersonaTemporal);

                                if (personas.Count <= posicionPersona || posicionPersona<0)
                                {
                                    Console.WriteLine("La persona no existe.");
                                }
                                else
                                {
                                    Console.WriteLine("Ingrese el nuevo nombre:");
                                    nombre = Console.ReadLine();
                                    Console.WriteLine("Ingrese el nuevo apellido:");
                                    apellido = Console.ReadLine();

                                    if (nombre.Trim() == string.Empty || apellido.Trim() == string.Empty)
                                    {
                                        Console.WriteLine("Los campos son obligatorios.");
                                    }
                                    else
                                    {
                                        personas[posicionPersona][0] = nombre;
                                        personas[posicionPersona][1] = apellido;

                                        Console.WriteLine("Información actualizada correctamente");
                                    }
                                }
                            }
                            else
                            {
                                Console.WriteLine("Dato incorrecto");
                            }

                            break;
                        case 4:
                            Console.WriteLine("-------------Lista de personas-----------------");

                            for (int i = 0; i < personas.Count; i++)
                            {
                                Console.WriteLine(i + ". " + personas[i][0] + " " + personas[i][1]);
                            }

                            Console.WriteLine("-----------------------------------------------");
                            Console.WriteLine("");

                            Console.WriteLine("Ingrese la persona que quiere eliminar:");

                            string posicionPersonaTemporalParaEliminar = Console.ReadLine();

                            if (int.TryParse(posicionPersonaTemporalParaEliminar, out x))
                            {
                                int posicionPersona = int.Parse(posicionPersonaTemporalParaEliminar);

                                if (personas.Count <= posicionPersona || posicionPersona < 0)
                                {
                                    Console.WriteLine("La persona no existe.");
                                }
                                else
                                {
                                    personas.RemoveAt(posicionPersona);

                                    Console.WriteLine("Persona eliminada correctamente");
                                }
                            }
                            else
                            {
                                Console.WriteLine("Dato incorrecto");
                            }

                            break;
                        case 5:


                            break;

                        default:
                            Console.WriteLine("La opción asignada no está definida en el menú.");

                            break;
                    }
                }
                else
                {
                    opcionSeleccionada = 0;

                    Console.WriteLine("El valor ingresado no es correcto");
                }

                if (opcionSeleccionada != 5)
                {
                    Console.ReadLine();
                }

                Console.Clear();
            }
        }
    }
}