﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AppFirst
{
    public partial class FrmPrincipal : Form
    {
        public FrmPrincipal()
        {
            InitializeComponent();
        }

        private void btnAgregar_Click(object sender, EventArgs e)
        {
            if (txtAgregar.Text.Trim() != string.Empty)
            {
                lbDatos.Items.Add(txtAgregar.Text);

                txtAgregar.Text = string.Empty;
            }
        }

        private void btnLeer_Click(object sender, EventArgs e)
        {
            if (lbDatos.SelectedItem != null)
            {
                txtLeer.Text = lbDatos.SelectedItem.ToString();
            }
        }

        private void btnEliminar_Click(object sender, EventArgs e)
        {
            if (lbDatos.SelectedItem != null)
            {
                lbDatos.Items.RemoveAt(lbDatos.SelectedIndex);
            }
        }

        private void btnLeerVarios_Click(object sender, EventArgs e)
        {
            if (lbMultiple.SelectedItems.Count > 0)
            {
                List<string> listaItems = new List<string>();

                foreach (Object item in lbMultiple.SelectedItems)
                {
                    listaItems.Add(item.ToString());
                }

                string datosConcatenados = "";

                foreach (var item in listaItems)
                {
                    datosConcatenados += item+",";
                }

                datosConcatenados = datosConcatenados.Substring(0, datosConcatenados.Length - 1);

                txtLeerVarios.Text = datosConcatenados;
            }
        }

        private void FrmPrincipal_Load(object sender, EventArgs e)
        {
            List<CPersona> listaCPersona = new List<CPersona>();

            listaCPersona.Add(new CPersona("1234567", "Kevin Arnold"));
            listaCPersona.Add(new CPersona("8989876", "Karla Sernadez"));
            listaCPersona.Add(new CPersona("7890898", "Marco Antonio"));
            listaCPersona.Add(new CPersona("1234324", "Astrid Valverde"));
            listaCPersona.Add(new CPersona("0967753", "Juan Perez"));

            lbObjeto.DataSource = listaCPersona;
        }

        private void btnObtener_Click(object sender, EventArgs e)
        {
            if (lbObjeto.SelectedItem != null)
            {
                txtObtener.Text = ((CPersona)lbObjeto.SelectedItem).codigo;
            }
        }
    }
}
