﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AppFirst
{
    public partial class FrmPrincipal : Form
    {
        public FrmPrincipal()
        {
            InitializeComponent();
        }

        private void FrmPrincipal_Load(object sender, EventArgs e)
        {
            dgvTabla.ColumnCount = 3;

            dgvTabla.Columns[0].Name = "DNI";
            dgvTabla.Columns[1].Name = "Nombre";
            dgvTabla.Columns[2].Name = "Apellido";

            dgvTabla.Rows.Add(new object[] { "77777777", "Kevin Arnold", "Arias Figueroa" });
            dgvTabla.Rows.Add(new object[] { "11111111", "Karla", "Sernadez Sánchez" });
            dgvTabla.Rows.Add(new object[] { "89898989", "Juan", "Ramirez Romero" });
        }

        private void btnLeer_Click(object sender, EventArgs e)
        {
            if (dgvTabla.SelectedRows.Count > 0 && dgvTabla.CurrentRow.Index < dgvTabla.Rows.Count - 1)
            {
                DataGridViewRow row = dgvTabla.SelectedRows[0];

                txtDocumentoIdentidad.Text = row.Cells[0].Value.ToString();
                txtNombre.Text = row.Cells["Nombre"].Value.ToString();
                txtApellido.Text = row.Cells["Apellido"].Value.ToString();
            }
            else
            {
                txtDocumentoIdentidad.Text = string.Empty;
                txtNombre.Text = string.Empty;
                txtApellido.Text = string.Empty;
            }
        }

        private void btnEliminar_Click(object sender, EventArgs e)
        {
            if (dgvTabla.SelectedRows.Count > 0 && dgvTabla.CurrentRow.Index < dgvTabla.Rows.Count - 1)
            {
                dgvTabla.Rows.RemoveAt(dgvTabla.CurrentRow.Index);
            }
        }

        private void btnGuardarCambios_Click(object sender, EventArgs e)
        {
            if (dgvTabla.SelectedRows.Count > 0 && dgvTabla.CurrentRow.Index < dgvTabla.Rows.Count - 1)
            {
                dgvTabla[0, dgvTabla.CurrentRow.Index].Value = txtDocumentoIdentidad.Text;
                dgvTabla[1, dgvTabla.CurrentRow.Index].Value = txtNombre.Text;
                dgvTabla[2, dgvTabla.CurrentRow.Index].Value = txtApellido.Text;
            }
        }
    }
}
