﻿using UnityEngine;

public class Meteor : MonoBehaviour
{
    private float _speed;

    private void Start()
    {
        gameObject.AddComponent<Rigidbody>();
        gameObject.GetComponent<Rigidbody>().useGravity = false;
        gameObject.GetComponent<Collider>().isTrigger = true;

        _speed = Random.Range(-0.25f, -0.1f);
    }

    private void Update()
    {
        transform.Rotate(new Vector3(Random.Range(1, 5), Random.Range(1, 5), Random.Range(1, 5)));

        if (transform.localPosition.z <= 0)
        {
            transform.position = new Vector3(Random.Range(-9.5f, 9.5f), 1.5f, Random.Range(30, 50));
        }

        transform.position += new Vector3(0, 0, _speed);
    }

    private void OnTriggerEnter(Collider other)
    {
        Destroy(gameObject);
        Destroy(other.gameObject);

        GameObject metor = GameObject.CreatePrimitive(PrimitiveType.Cube);

        metor.transform.localScale = new Vector3(1, 1, 1);
        metor.transform.position = new Vector3(Random.Range(-9.5f, 9.5f), 1.5f, Random.Range(30, 50));

        metor.AddComponent<Meteor>();
    }
}