﻿using UnityEngine;

public class Avion : MonoBehaviour
{
    private bool _arrowPress;

    private void Start() { }

    private void Update()
    {
        _arrowPress = false;

        if (Input.GetKeyDown(KeyCode.LeftControl))
        {
            GameObject p1 = GameObject.CreatePrimitive(PrimitiveType.Sphere);
            GameObject p2 = GameObject.CreatePrimitive(PrimitiveType.Sphere);

            p1.transform.localScale = new Vector3(0.2f, 0.2f, 0.2f);
            p2.transform.localScale = new Vector3(0.2f, 0.2f, 0.2f);

            float xTemp = transform.localPosition.x;
            float yTemp = transform.localPosition.y;
            float zTemp = transform.localPosition.z;

            p1.transform.localPosition = new Vector3(xTemp - 0.87f, yTemp - 0.5f, zTemp - 0.6f);
            p2.transform.localPosition = new Vector3(xTemp + 0.87f, yTemp - 0.5f, zTemp - 0.6f);

            p1.AddComponent<Proyectil>();
            p2.AddComponent<Proyectil>();
        }

        if (Input.GetKey(KeyCode.LeftArrow))
        {
            _arrowPress = true;

            if (transform.rotation.z < 0.25)
            {
                transform.Rotate(new Vector3(0, 0, 2));
            }

            if (transform.position.x > -10)
            {
                transform.position += new Vector3(-0.3f, 0, 0);
            }
        }

        if (Input.GetKey(KeyCode.RightArrow))
        {
            _arrowPress = true;

            if (transform.rotation.z > -0.25)
            {
                transform.Rotate(new Vector3(0, 0, -2));
            }

            if (transform.position.x < 10)
            {
                transform.position += new Vector3(0.3f, 0, 0);
            }
        }

        if (!_arrowPress)
        {
            if (transform.rotation.z < 0)
            {
                transform.Rotate(new Vector3(0, 0, 2));
            }

            if (transform.rotation.z > 0)
            {
                transform.Rotate(new Vector3(0, 0, -2));
            }
        }
    }
}